<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('contratti', function (Blueprint $table) {
            if (!Schema::hasColumn('contratti', 'template_id')) {
                $table->foreignId('template_id')->nullable()->after('id');
                $table->foreign('template_id', 'contratti_template_id_foreign')
                    ->references('id')
                    ->on('contratto_templates')
                    ->onDelete('set null');
            }
        });
    }

    public function down()
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->dropForeign(['template_id']);
            $table->dropColumn('template_id');
        });
    }
}; 