<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contratti', function (Blueprint $table) {
            if (!Schema::hasColumn('contratti', 'yousign_procedure_id')) {
                $table->string('yousign_procedure_id')->nullable()->after('pdf_path');
            }
            if (!Schema::hasColumn('contratti', 'yousign_signer_id')) {
                $table->string('yousign_signer_id')->nullable()->after('yousign_procedure_id');
            }
            if (!Schema::hasColumn('contratti', 'yousign_status')) {
                $table->string('yousign_status')->nullable()->after('yousign_signer_id');
            }
            if (!Schema::hasColumn('contratti', 'signed_at')) {
                $table->timestamp('signed_at')->nullable()->after('yousign_status');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contratti', function (Blueprint $table) {
            $columns = ['yousign_procedure_id', 'yousign_signer_id', 'yousign_status', 'signed_at'];
            foreach ($columns as $column) {
                if (Schema::hasColumn('contratti', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
