<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        Schema::create('contratto_corso', function (Blueprint $table) {
            $table->id();
            $table->foreignId('contratto_id')->constrained('contratti')->cascadeOnDelete();
            $table->foreignId('corso_id')->constrained('corsi')->cascadeOnDelete();
            $table->timestamps();
        });

        // Migra i dati esistenti
        DB::statement('
            INSERT INTO contratto_corso (contratto_id, corso_id, created_at, updated_at)
            SELECT id, corso_id, NOW(), NOW()
            FROM contratti
            WHERE corso_id IS NOT NULL
        ');

        // Rimuovi la vecchia colonna
        Schema::table('contratti', function (Blueprint $table) {
            $table->dropForeign(['corso_id']);
            $table->dropColumn('corso_id');
        });
    }

    public function down()
    {
        // Riaggiungi la colonna corso_id
        Schema::table('contratti', function (Blueprint $table) {
            $table->foreignId('corso_id')->nullable()->constrained('corsi')->nullOnDelete();
        });

        // Migra i dati indietro
        DB::statement('
            UPDATE contratti c
            JOIN contratto_corso cc ON c.id = cc.contratto_id
            SET c.corso_id = cc.corso_id
        ');

        Schema::dropIfExists('contratto_corso');
    }
}; 