<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->string('tipo_pagamento')->nullable(); // bancario o postale
            $table->string('intestazione_conto')->nullable();
            $table->string('istituto_postale')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->dropColumn([
                'tipo_pagamento',
                'intestazione_conto',
                'istituto_postale'
            ]);
        });
    }
};
