<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->string('numero_decreto')->nullable();
            $table->integer('numero_posizioni')->nullable();
            $table->string('regime_tempo')->nullable();
            $table->string('gsd')->nullable();
            $table->string('ssd')->nullable();
            $table->string('numero_decreto_dg')->nullable();
            $table->date('data_delibera_dipartimento')->nullable();
            $table->date('data_delibera_cda')->nullable();
        });
    }

    public function down()
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->dropColumn([
                'numero_decreto',
                'numero_posizioni',
                'regime_tempo',
                'gsd',
                'ssd',
                'numero_decreto_dg',
                'data_delibera_dipartimento',
                'data_delibera_cda',
            ]);
        });
    }

}; 
