<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\FundingBody;

class FundingBodiesSeeder extends Seeder
{
    public function run(): void
    {
        $fundingBodies = [
            [
                'name' => 'Università Telematica degli Studi IUL',
                'type' => 'university',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Commissione Europea',
                'type' => 'eu',
                'country' => 'Europa',
                'is_active' => true,
            ],
            [
                'name' => 'INDIRE',
                'type' => 'national',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Erasmus+ Programme',
                'type' => 'eu',
                'country' => 'Europa',
                'is_active' => true,
            ],
            [
                'name' => 'Ministero dell\'Università e della Ricerca',
                'type' => 'national',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Ministero della Salute - DG Prevenzione sanitaria',
                'type' => 'national',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'European Commission',
                'type' => 'eu',
                'country' => 'Europa',
                'is_active' => true,
            ],
            [
                'name' => 'Università per Stranieri di Perugia',
                'type' => 'university',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'NEISOS, Arkage',
                'type' => 'private',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Atomtech s.r.l',
                'type' => 'private',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'LYNK INTERNATIONAL S.r.l',
                'type' => 'private',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'University of Bath',
                'type' => 'university',
                'country' => 'Regno Unito',
                'is_active' => true,
            ],
            [
                'name' => 'Serramenti Falchetti Srl',
                'type' => 'private',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Università per Stranieri di Siena',
                'type' => 'university',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Università degli studi di Bologna',
                'type' => 'university',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Camara Oficial de Comercio e Industria de Badajoz',
                'type' => 'other',
                'country' => 'Spagna',
                'is_active' => true,
            ],
            [
                'name' => 'ECC Verein fur interdisziplinaere Bildung und Beratung',
                'type' => 'other',
                'country' => 'Austria',
                'is_active' => true,
            ],
            [
                'name' => 'Fondo per la Repubblica Digitale -- Impresa Sociale S.r.l.',
                'type' => 'private',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Fondo per la Repubblica Digitale Impresa sociale',
                'type' => 'private',
                'country' => 'Italia',
                'is_active' => true,
            ],
            [
                'name' => 'Agenzia Nazionale Erasmus + Slovacchia',
                'type' => 'eu',
                'country' => 'Slovacchia',
                'is_active' => true,
            ],
            [
                'name' => 'Avviso Fondo per la Crescita Sostenibile',
                'type' => 'national',
                'country' => 'Italia',
                'is_active' => true,
            ],
        ];

        foreach ($fundingBodies as $fundingBody) {
            FundingBody::create($fundingBody);
        }
    }
} 