<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TipoContratto;
use Illuminate\Support\Str;

class TipiContrattoSeeder extends Seeder
{
    public function run()
    {
        $tipiContratto = [
            [
                'id' => 1,
                'nome' => 'Contratto personale strutturato',
                'nome_breve' => 'Personale strutturato',
                'colore' => 'primary',
                'slug' => 'personale-strutturato',
            ],
            [
                'id' => 2,
                'nome' => 'Incarico di collaborazione occasionale per attività di docenza',
                'nome_breve' => 'Docenza',
                'colore' => 'success',
                'slug' => 'docenza',
            ],
            [
                'id' => 3,
                'nome' => 'Incarico di collaborazione occasionale per tutoraggio',
                'nome_breve' => 'Tutoraggio',
                'colore' => 'warning',
                'slug' => 'tutoraggio',
            ],
            [
                'id' => 4,
                'nome' => 'Contratto di lavoro dipendente',
                'nome_breve' => 'Lavoro dipendente',
                'colore' => 'info',
                'slug' => 'lavoro-dipendente',
            ],
            [
                'id' => 5,
                'nome' => 'Incarico di collaborazione occasionale',
                'nome_breve' => 'Collaborazione occasionale',
                'colore' => 'danger',
                'slug' => 'collaborazione-occasionale',
            ],
            [
                'id' => 6,
                'nome' => 'Contratto di collaborazione coordinata e continuativa',
                'nome_breve' => 'COCOCO',
                'colore' => 'secondary',
                'slug' => 'cococo',
            ],
            [
                'id' => 7,
                'nome' => 'Contratto di collaborazione autonoma',
                'nome_breve' => 'P.IVA',
                'colore' => 'gray',
                'slug' => 'piva',
            ],
            [
                'id' => 8,
                'nome' => 'TEST',
                'nome_breve' => 'TEST',
                'colore' => 'gray',
                'slug' => 'test',
            ],
        ];

        foreach ($tipiContratto as $tipo) {
            $existingTipo = TipoContratto::where('id', $tipo['id'])->first();
            if ($existingTipo) {
                $existingTipo->update($tipo);
            } else {
                TipoContratto::create($tipo);
            }
        }
    }
}