<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class TipologiaUtentePermissionsSeeder extends Seeder
{
    public function run(): void
    {
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Reset completo dei ruoli
        Role::where('name', 'manager_didattico')->delete();
        Role::where('name', 'admin')->delete();
        Role::where('name', 'staff')->delete();

        // Creiamo il ruolo manager_didattico
        $managerDidattico = Role::create(['name' => 'manager_didattico', 'guard_name' => 'web']);

        // Create permissions
        $permissions = [
            // ... existing permissions ...
        ];

        // Creo il ruolo Amministrativo se non esiste
        $amministrativo = Role::firstOrCreate(['name' => 'Amministrativo', 'guard_name' => 'web']);

        // Lista di tutte le risorse disponibili
        $allResources = [
            'anagrafica',
            'contratto',
            'corso',
            'event',
            'funding::body',
            'project',
            'budget::category',
            'budget::subcategory',
            'budget::item',
            'shield',
            'user',
            'contratto_template',
        ];

        // Risorse da escludere per l'amministrativo
        $excludedResources = [
            'shield',
            'user',
            'project',
            'funding::body',
            'budget::category',
            'budget::subcategory',
            'budget::item',
        ];

        // Risorse permesse
        $allowedResources = array_diff($allResources, $excludedResources);

        // Tipi di permessi base
        $permissionTypes = [
            'view',
            'view_any',
            'create',
            'update',
            'delete',
            'delete_any',
            'restore',
            'restore_any',
            'replicate',
            'reorder',
        ];

        $amministrativoPermissions = [];
        foreach ($allowedResources as $resource) {
            foreach ($permissionTypes as $type) {
                $permissionName = "{$type}_{$resource}";
                $amministrativoPermissions[] = $permissionName;
                Permission::firstOrCreate(['name' => $permissionName, 'guard_name' => 'web']);
            }
        }

        // Assegno i permessi al ruolo Amministrativo
        $amministrativo->syncPermissions($amministrativoPermissions);

        // Gestione super admin
        $superAdmin = Role::where('name', 'super_admin')->first();
        if ($superAdmin) {
            $permissions = [
                'view_tipologia::utente',
                'view_any_tipologia::utente',
                'create_tipologia::utente',
                'update_tipologia::utente',
                'delete_tipologia::utente',
                'delete_any_tipologia::utente',
                'restore_tipologia::utente',
                'restore_any_tipologia::utente',
                'replicate_tipologia::utente',
                'reorder_tipologia::utente',
                'force_delete_tipologia::utente',
                'force_delete_any_tipologia::utente',

                // Permessi per Proposte Corsi
                'view_proposta::corso',
                'view_any_proposta::corso',
                'create_proposta::corso',
                'update_proposta::corso',
                'delete_proposta::corso',
                'delete_any_proposta::corso',
            ];

            foreach ($permissions as $permission) {
                Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
            }

            $superAdmin->givePermissionTo($permissions);
        }

        // Permessi per Staff IUL
        $staff = Role::where('name', 'Staff IUL')->first();
        if ($staff) {
            $staffPermissions = [
                // Permessi per Enti Finanziatori (solo visualizzazione)
                'view_funding::body',
                'view_any_funding::body',

                // Permessi per Progetti (visualizzazione e creazione base)
                'view_project',
                'view_any_project',
                'create_project',
                'update_project',
            ];

            foreach ($staffPermissions as $permission) {
                Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
            }

            $staff->givePermissionTo($staffPermissions);
        }

        // Manager Didattico (versione completa con tutti i permessi)
        $managerDidattico = Role::where('name', 'manager_didattico')->first();
        if ($managerDidattico) {
            $managerPermissions = [
                // Permessi per Proposte Corsi
                'view_proposta::corso',
                'view_any_proposta::corso',
                'create_proposta::corso',
                'update_proposta::corso',
                'delete_proposta::corso',
                
                // Permessi per Corsi
                'view_corso',
                'view_any_corso',
                'create_corso',
                'update_corso',
                'delete_corso',
                
                // Permessi per Eventi
                'view_event',
                'view_any_event',
                'create_event',
                'update_event',
                'delete_event',
                
                // Permessi per Anagrafiche
                'view_anagrafica',
                'view_any_anagrafica',
                'create_anagrafica',
                'update_anagrafica',
                
                // Permessi per Contratti
                'view_contratto',
                'view_any_contratto',
                'create_contratto',
                'update_contratto',
            ];

            foreach ($managerPermissions as $permission) {
                Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
            }

            $managerDidattico->syncPermissions($managerPermissions);
        }
    }
} 