<?php

namespace Database\Seeders;

use App\Models\TipologiaUtente;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class TipologieUtenteSeeder extends Seeder
{
    public function run()
    {
        $tipologie = [
            [
                'nome' => 'Personale strutturato',
                'descrizione' => 'Professori e ricercatori IUL (dipendenti IUL subordinati)',
                'regole' => [
                    'professori' => [
                        [
                            'tipo' => 'tempo_pieno',
                            'ore_anno' => 1500,
                            'ore_giorno' => 6,
                            'giorni_mese' => 22,
                            'ore_mese' => 125,
                            'tempo_produttivo' => 1150
                        ],
                        [
                            'tipo' => 'tempo_definito',
                            'ore_anno' => 750,
                            'ore_giorno' => 3,
                            'giorni_mese' => 22,
                            'ore_mese' => 62.5,
                            'tempo_produttivo' => 500
                        ]
                    ],
                    'ricercatori' => [
                        [
                            'tipo' => 'tempo_pieno',
                            'ore_anno' => 1500,
                            'ore_giorno' => 6,
                            'giorni_mese' => 22,
                            'ore_mese' => 125,
                            'tempo_produttivo' => 1150
                        ],
                        [
                            'tipo' => 'tempo_definito',
                            'ore_anno' => 750,
                            'ore_giorno' => 3,
                            'giorni_mese' => 22,
                            'ore_mese' => 62.5,
                            'tempo_produttivo' => 550
                        ]
                    ]
                ]
            ],
            [
                'nome' => 'Personale docente a contratto',
                'descrizione' => 'Docenti esterni con contratto',
                'regole' => [
                    'note' => 'Va verificato quanto previsto dal contratto individuale.'
                ]
            ],
            [
                'nome' => 'Personale tutor didattici',
                'descrizione' => 'Tutor che supportano l\'attività didattica',
                'regole' => [
                    'note' => 'Va verificato quanto previsto dal contratto individuale.'
                ]
            ],
            [
                'nome' => 'Personale Tecnico Amministrativo',
                'descrizione' => 'Personale tecnico amministrativo',
                'regole' => [
                    'ore_anno' => 1720,
                    'ore_giorno' => 8,
                    'note' => 'Il CCNL per il calcolo del costo orario e/o giornaliero prevede un impegno orario annuale di 1720 ore. In IUL si rendiconta a costi reali, utilizzando il costo orario indicato nella tabella costi orari.'
                ]
            ],
            [
                'nome' => 'Collaboratori occasionali',
                'descrizione' => 'Collaboratori con prestazioni occasionali',
                'regole' => [
                    'note' => 'Va verificato quanto previsto dal contratto individuale.'
                ]
            ],
            [
                'nome' => 'Collaboratori cococo',
                'descrizione' => 'Collaboratori coordinati e continuativi',
                'regole' => [
                    'note' => 'Va verificato quanto previsto dal contratto individuale.'
                ]
            ],
            [
                'nome' => 'Consulenti p.iva',
                'descrizione' => 'Professionisti con partita IVA',
                'regole' => [
                    'note' => 'Va verificato quanto previsto dal contratto individuale.'
                ]
            ]
        ];

        foreach ($tipologie as $tipologia) {
            TipologiaUtente::updateOrCreate(
                ['slug' => Str::slug($tipologia['nome'])],
                [
                    'nome' => $tipologia['nome'],
                    'descrizione' => $tipologia['descrizione'],
                    'regole' => $tipologia['regole']
                ]
            );
        }
    }
} 