<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Hash;

class UfficioLegaleSeeder extends Seeder
{
    public function run(): void
    {
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Creo il ruolo "ufficio legale" se non esiste
        $ufficioLegale = Role::firstOrCreate(['name' => 'ufficio legale', 'guard_name' => 'web']);

        // Lista dei permessi da assegnare
        $permissions = [
            'page_CreateAnagrafica',
            'page_Anagrafica',
            'page_GestioneContatti',
            'page_CreateContratti',
            'page_GestioneContratti',
            'page_GestioneCorsi',
            'page_GestioneCategorieCorsi',
            'page_PropostaCorsi',
            'view_firmatario',
            'view_any_firmatario',
            'view_corso',
            'view_any_corso',
            'view_candidature',
            'view_any_candidature',
            'create_candidature',
            'update_candidature',
            'view_proposta::corso',
            'view_any_proposta::corso',
            'create_proposta::corso',
            'update_proposta::corso',
            // Permessi per ContrattoTemplate
            'view_contratto::template',
            'view_any_contratto::template',
            'create_contratto::template',
            'update_contratto::template',
            'delete_contratto::template',
            'delete_any_contratto::template',
            // Permessi per i contratti
            'view_contratto',
            'view_any_contratto',
            'create_contratto',
            'update_contratto',
            'delete_contratto',
            'delete_any_contratto',
            // Permessi per il RelationManager dei contratti nel template
            'viewAny_contratti',
            'view_contratti',
            'create_contratti',
            'update_contratti',
            'delete_contratti',
            'deleteAny_contratti',
        ];

        // Assegno i permessi al ruolo
        foreach ($permissions as $permission) {
            $perm = Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
            $ufficioLegale->givePermissionTo($perm);
        }

        // Creo l'utente Maria Giulia Spriano
        $mariaSpriano = User::firstOrCreate(
            ['email' => 'm.spriano@iuline.it'],
            [
                'name' => 'Maria Giulia Spriano',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
            ]
        );

        // Assegno il ruolo ufficio legale
        $mariaSpriano->assignRole('ufficio legale');

        // Creo l'utente Ufficio Amministrativo
        $ufficioAmministrativo = User::firstOrCreate(
            ['email' => 'ufficio.amministrativo@iuline.it'],
            [
                'name' => 'Ufficio Amministrativo',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
            ]
        );

        // Assegno il ruolo amministrativo e i permessi aggiuntivi per le proposte corsi
        $ufficioAmministrativo->assignRole('Amministrativo');
        $ufficioAmministrativo->givePermissionTo([
            'page_PropostaCorsi',
            'view_proposta::corso',
            'view_any_proposta::corso',
            'create_proposta::corso',
            'update_proposta::corso',
        ]);
    }
} 