# Documentazione Contratti

<!-- Panoramica -->
<div class="bg-slate-50 dark:bg-gray-800 p-4 rounded-lg mb-8 text-gray-600 dark:text-gray-200 shadow-xl">
  Il sistema di gestione dei contratti è progettato per gestire l'intero ciclo di vita 
  dei contratti, dalla creazione alla firma digitale. Il sistema supporta diversi tipi 
  di contratti, con gestione automatizzata del workflow di firma e monitoraggio dello stato.
</div>

<!-- Tipologie di Contratti -->
# Tipologie di Contratti
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h3 class="text-xl font-semibold mb-4 text-slate-600 dark:text-slate-400">Contratti di Docenza</h3>
    <p class="text-gray-600 dark:text-gray-300">
      Contratti per l'insegnamento nei corsi universitari, con gestione di CFU, 
      ore di docenza e periodo di insegnamento.
    </p>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h3 class="text-xl font-semibold mb-4 text-slate-600 dark:text-slate-400">
      Contratti Amministrativi
    </h3>
    <p class="text-gray-600 dark:text-gray-300">
      Contratti per il personale tecnico-amministrativo, con gestione di mansioni 
      e responsabilità specifiche.
    </p>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h3 class="text-xl font-semibold mb-4 text-slate-600 dark:text-slate-400">
      Contratti di Collaborazione
    </h3>
    <p class="text-gray-600 dark:text-gray-300">
      Contratti per collaboratori esterni, con gestione di progetti specifici e 
      obiettivi da raggiungere.
    </p>
  </div>
</div>

<!-- Struttura dei Dati -->
# Struttura dei Dati

<!-- Dati Principali -->
## Dati Principali
<div class="bg-yellow-50 dark:bg-gray-700 p-4 rounded-lg mb-6 text-gray-600 dark:text-gray-200">
  Informazioni fondamentali presenti in ogni contratto:
</div>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Anagrafica</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Collegamento con l'anagrafica del contraente</li>
      <li>Verifica automatica della completezza dei dati anagrafici</li>
      <li>Gestione dello storico contratti per anagrafica</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Periodo Contrattuale</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Data di inizio e fine del contratto</li>
      <li>Gestione automatica delle scadenze</li>
      <li>Notifiche automatiche per rinnovi e scadenze</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Compenso</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Importo del contratto in formato valuta</li>
      <li>Gestione di diverse modalità di pagamento</li>
      <li>Tracciamento dei pagamenti effettuati</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Tipologia</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Classificazione del tipo di contratto</li>
      <li>Template specifici per ogni tipologia</li>
      <li>Workflow personalizzato per tipo</li>
    </ul>
  </div>
</div>

<!-- Processo di Firma -->
## Processo di Firma
<div class="bg-green-50 dark:bg-gray-700 p-4 rounded-lg mb-6 text-gray-600 dark:text-gray-200 shadow-2xl">
  Il sistema implementa un workflow completo per la firma digitale dei contratti:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Stati del Contratto</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Non inviato: contratto creato ma non ancora inviato per la firma</li>
      <li>In attesa di firma: inviato e in attesa di firme</li>
      <li>Firmato: processo di firma completato</li>
      <li>Rifiutato: firma rifiutata da uno dei firmatari</li>
      <li>Scaduto: tempo per la firma esaurito</li>
      <li>In errore: problemi durante il processo di firma</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Firmatari</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Gestione di firmatari multipli</li>
      <li>Ordine di firma configurabile</li>
      <li>Notifiche automatiche ai firmatari</li>
      <li>Tracciamento dello stato di firma per ogni firmatario</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Integrazione YouSign</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Firma digitale legalmente valida</li>
      <li>Processo di firma guidato</li>
      <li>Verifica dell'identità dei firmatari</li>
      <li>Conservazione a norma dei documenti firmati</li>
    </ul>
  </div>
</div>

<!-- Gestione Template -->
## Gestione Template
<div class="bg-purple-50 dark:bg-gray-700 p-4 rounded-lg mb-6 text-gray-600 dark:text-gray-200">
  Sistema avanzato di template per la generazione dei contratti:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Variabili Dinamiche</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Sostituzione automatica dei dati anagrafici</li>
      <li>Campi personalizzabili per tipo di contratto</li>
      <li>Formattazione automatica di date e importi</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Template Personalizzabili</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Editor visuale per la creazione di template</li>
      <li>Supporto per contenuti HTML e stili CSS</li>
      <li>Versioning dei template</li>
    </ul>
  </div>
</div>

<!-- Funzionalità Speciali -->
# Funzionalità Speciali

<!-- Gestione Documenti -->
## Gestione Documenti
<div class="bg-indigo-50 dark:bg-gray-700 p-4 rounded-lg mb-6 text-gray-600 dark:text-gray-200">
  Funzionalità avanzate per la gestione documentale:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Generazione PDF</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Conversione automatica in PDF</li>
      <li>Formattazione professionale</li>
      <li>Gestione di header e footer personalizzati</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Archiviazione</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Storage sicuro dei documenti</li>
      <li>Versionamento dei contratti</li>
      <li>Backup automatico</li>
    </ul>
  </div>
</div>

<!-- Monitoraggio e Reporting -->
## Monitoraggio e Reporting
<div class="bg-pink-50 dark:bg-gray-700 p-4 rounded-lg mb-6 text-gray-600 dark:text-gray-200">
  Strumenti avanzati per il monitoraggio e l'analisi:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Dashboard</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Vista d'insieme dei contratti attivi</li>
      <li>Statistiche in tempo reale</li>
      <li>Indicatori di performance chiave</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Notifiche</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Alert automatici per scadenze</li>
      <li>Notifiche di stato firma</li>
      <li>Promemoria personalizzabili</li>
    </ul>
  </div>
</div>

<!-- Calendario -->
## Calendario
<div class="bg-teal-50 dark:bg-gray-700 p-4 rounded-lg mb-6 text-gray-600 dark:text-gray-200">
  Integrazione con il calendario per la gestione delle scadenze:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Eventi Automatici</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Creazione automatica eventi per scadenze</li>
      <li>Sincronizzazione con calendario di sistema</li>
      <li>Promemoria configurabili</li>
    </ul>
  </div>
  <div class="bg-slate-50 dark:bg-gray-900 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600 dark:text-slate-400">Visualizzazione</h4>
    <ul class="list-disc pl-5  text-gray-600 dark:text-gray-300">
      <li>Vista mensile, settimanale e giornaliera</li>
      <li>Filtri per tipo di contratto</li>
      <li>Raggruppamento per firmatario</li>
    </ul>
  </div>
</div>