<div class="space-y-2">
    <p class="text-sm text-gray-600">Clicca su una variabile per copiarla</p>
    
    <div class="grid grid-cols-1 gap-2">
        @php
            $variables = [
                'Anagrafica' => [
                    'nome' => 'Nome',
                    'cognome' => 'Cognome',
                    'indirizzo' => 'Indirizzo',
                    'citta' => 'Città',
                ],
                'Date' => [
                    'data_oggi' => 'Data odierna',
                    'data_inizio' => 'Data inizio',
                    'data_fine' => 'Data fine',
                ],
                'Contratto' => [
                    'compenso' => 'Compenso',
                    'ore_totali' => 'Ore totali',
                ],
                'Corso' => [
                    'corso' => 'Nome corso',
                    'ssd' => 'SSD',
                    'cfu' => 'CFU',
                    'semestre' => 'Semestre',
                    'anno_accademico' => 'Anno accademico',
                ],
            ];
        @endphp

        @foreach($variables as $category => $vars)
            <div class="bg-gray-50 rounded-lg p-3">
                <h3 class="font-medium text-gray-900 mb-2">{{ $category }}</h3>
                <div class="grid grid-cols-1 gap-1">
                    @foreach($vars as $key => $label)
                        <button 
                            type="button"
                            class="text-left px-2 py-1 text-sm text-gray-600 hover:bg-gray-100 rounded transition-colors cursor-pointer flex items-center justify-between group"
                            x-data
                            x-on:click="
                                const text = '{!! '{' !!}{!! '{' !!}{{ $key }}{!! '}' !!}{!! '}' !!}';
                                navigator.clipboard.writeText(text);
                                $dispatch('notify', {
                                    message: 'Variabile copiata!',
                                    type: 'success'
                                })
                            "
                        >
                            <span>{{ $label }}</span>
                            <code class="text-xs text-gray-400 group-hover:text-primary-500">{!! '{' !!}{!! '{' !!}{{ $key }}{!! '}' !!}{!! '}' !!}</code>
                        </button>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>
</div> 