<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header img {
            max-width: 200px;
            height: auto;
        }
        .content {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 5px;
        }
        .details {
            background-color: #f5f5f5;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .details-item {
            margin-bottom: 10px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="{{ url('assets/loghi/logo-iul2.png') }}" alt="Logo IUL">
        </div>
        
        <div class="content">
            <h2>Nuova proposta corso</h2>
            
            <p>È stata inviata una nuova proposta corso per approvazione.</p>
            
            <div class="details">
                <div class="details-item">
                    <strong>Titolo:</strong> {{ $propostaCorso->titolo }}
                </div>
                <div class="details-item">
                    <strong>Tipologia:</strong> {{ $propostaCorso->tipologia_percorso }}
                </div>
                <div class="details-item">
                    <strong>CFU:</strong> {{ $propostaCorso->cfu }}
                </div>
                <div class="details-item">
                    <strong>Anno Accademico:</strong> {{ $propostaCorso->anno_accademico }}
                </div>
            </div>
            
            <p>In allegato trovi il PDF con tutti i dettagli della proposta.</p>
            
            <p>Cordiali saluti,<br>
            Università Telematica degli Studi IUL</p>
        </div>
        
        <div class="footer">
            <p>Questa email è stata inviata da Università Telematica degli Studi IUL</p>
            <p>Non rispondere a questa email. Per assistenza, contattare il supporto.</p>
        </div>
    </div>
</body>
</html> 