<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Contratto Personalizzato</title>
    <style>
        @page { 
            margin: 180px 50px;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.6;
            margin: 0;
            padding: 0;
        }
        #header { 
            position: fixed; 
            left: 0px; 
            top: -160px; 
            right: 0px; 
            text-align: center;
        }
        .logo {
            position: absolute;
            top: 0;
            left: 20px;
            width: 150px;
            height: auto;
        }
        #content {
            margin: 0 20px;
        }
        .date-location {
            text-align: right;
            margin-bottom: 30px;
        }
        .title {
            font-weight: bold;
            margin: 30px 0;
            text-align: center;
            text-transform: uppercase;
            font-size: 14px;
        }
        .bullet-list {
            list-style-type: none;
            padding-left: 20px;
        }
        .bullet-list li {
            margin-bottom: 10px;
            text-indent: -20px;
            padding-left: 20px;
        }
        .bullet-list li:before {
            content: "•";
            padding-right: 10px;
        }
        .signature {
            margin-top: 50px;
        }
        .signature-line {
            border-top: 1px solid black;
            width: 200px;
            display: inline-block;
            margin-top: 30px;
        }
        .digital-signature-notice {
            font-size: 10px;
            font-style: italic;
            margin-top: 40px;
            color: #666;
        }
        #footer { 
            position: fixed; 
            left: 0px; 
            bottom: -160px; 
            right: 0px; 
            height: 150px;
            padding-left: 20px;
            color: #6B9AC4;
            font-size: 10px;
            line-height: 1.4;
        }
        #footer p {
            margin: 0;
        }
        h4 {
            margin-top: 20px;
            margin-bottom: 10px;
            font-size: 13px;
        }

        /* Stili per il contenuto del RichEditor */
        h2 {
            color: #333;
            margin-top: 20px;
            margin-bottom: 10px;
            font-size: 14px;
        }

        h3 {
            color: #444;
            margin-top: 15px;
            margin-bottom: 8px;
            font-size: 13px;
        }

        ul, ol {
            margin-bottom: 15px;
            padding-left: 20px;
        }

        blockquote {
            margin: 15px 0;
            padding: 10px 20px;
            border-left: 3px solid #ccc;
            background-color: #f9f9f9;
        }

        p {
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div id="header">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('images/logo-iul2.png'))) }}" class="logo" alt="Logo IUL">
    </div>

    <div id="footer">
        <p>50122 Firenze</p>
        <p>Via M. Buonarroti 10</p>
        <p>cod. fis./p. iva 05666530489</p>
        <p>&nbsp;</p>
        <p>tel. +39 055 0380900</p>
        <p>www.iuline.it</p>
    </div>

    <div id="content">
        <div class="date-location">
            <p>Firenze, {{ \Carbon\Carbon::now()->format('d/m/Y') }}</p>
        </div>

        {!! $content !!}

        <div class="digital-signature-notice">
            <p>Documento informatico firmato digitalmente ai sensi del T.U. 445/2000 e del D.Lgs. 82/2005 e rispettive norme collegate, il quale sostituisce il documento cartaceo e la firma autografa</p>
        </div>
    </div>
</body>
</html> 