<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Contratto Personale Strutturato</title>
    <style>
        @page { 
            margin: 180px 50px;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.6;
            margin: 0;
            padding: 0;
        }
        #header { 
            position: fixed; 
            left: 0px; 
            top: -160px; 
            right: 0px; 
            text-align: center;
        }
        .logo {
            position: absolute;
            top: 0;
            left: 20px;
            width: 150px;
            height: auto;
        }
        #content {
            margin: 0 20px;
        }
        .date-location {
            text-align: right;
            margin-bottom: 30px;
        }
        .title {
            font-weight: bold;
            margin: 30px 0;
            text-align: center;
            text-transform: uppercase;
            font-size: 14px;
        }
        .bullet-list {
            list-style-type: none;
            padding-left: 20px;
        }
        .bullet-list li {
            margin-bottom: 10px;
            text-indent: -20px;
            padding-left: 20px;
        }
        .bullet-list li:before {
            content: "•";
            padding-right: 10px;
        }
        .signature {
            margin-top: 50px;
        }
        .signature-line {
            border-top: 1px solid black;
            width: 200px;
            display: inline-block;
            margin-top: 30px;
        }
        .digital-signature-notice {
            font-size: 10px;
            font-style: italic;
            margin-top: 40px;
            color: #666;
        }
        #footer { 
            position: fixed; 
            left: 0px; 
            bottom: -160px; 
            right: 0px; 
            height: 150px;
            padding-left: 20px;
            color: #6B9AC4;
            font-size: 10px;
            line-height: 1.4;
        }
        #footer p {
            margin: 0;
        }
        h4 {
            margin-top: 20px;
            margin-bottom: 10px;
            font-size: 13px;
        }
    </style>
</head>
<body>
    <div id="header">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('images/logo-iul2.png'))) }}" class="logo" alt="Logo IUL">
    </div>

    <div id="footer">
        <p>50122 Firenze</p>
        <p>Via M. Buonarroti 10</p>
        <p>cod. fis./p. iva 05666530489</p>
        <p>&nbsp;</p>
        <p>tel. +39 055 0380900</p>
        <p>www.iuline.it</p>
    </div>

    <div id="content">
        <div class="date-location">
            <p>Firenze, {{ \Carbon\Carbon::now()->format('d/m/Y') }}</p>
        </div>

        <div class="title">
            CONTRATTO DI LAVORO SUBORDINATO A TEMPO DETERMINATO<br>
            PERSONALE STRUTTURATO
        </div>

        <p>L'Università Telematica degli Studi IUL con sede legale in Firenze, via Michelangelo Buonarroti 10 – 50122, Codice Fiscale/P.IVA 05666530489, nella persona del Direttore Generale Dott. Massimiliano Bizzocchi, nato a Roma il 27/11/1974, C.F. BZZMSM74S27H501A</p>

        <h4>PREMESSO CHE</h4>
        <ul class="bullet-list">
            <li>Con Decreto presidenziale {{ $contratto->numero_decreto }} è stata avviata la procedura di reclutamento di n. {{ $contratto->numero_posizioni }} Ricercatore universitario a tempo determinato, in regime di tempo {{ $contratto->regime_tempo }}, ai sensi dell'art. 24, della legge del 30 dicembre 2010 n. 240, Gruppo Scientifico Disciplinare GSD: {{ $contratto->gsd }}; SSD: {{ $contratto->ssd }};</li>
            <li>Con decreto del Direttore Generale n. {{ $contratto->numero_decreto_dg }} sono stati approvati gli atti concorsuali;</li>
            <li>Con la Delibera del Consiglio di Dipartimento del {{ $contratto->data_delibera_dipartimento ? \Carbon\Carbon::parse($contratto->data_delibera_dipartimento)->format('d/m/Y') : '________' }} è stata proposta la chiamata del candidato prescelto {{ $contratto->anagrafica->nome_completo }};</li>
            <li>Con la Delibera del Consiglio di Amministrazione del {{ $contratto->data_delibera_cda ? \Carbon\Carbon::parse($contratto->data_delibera_cda)->format('d/m/Y') : '________' }} è stata approvata la proposta di chiamata di cui al precedente punto;</li>
            <li>Ai sensi della normativa vigente, deve essere stipulato apposito contratto individuale di lavoro tra l'Università Telematica degli Studi IUL e {{ $contratto->anagrafica->nome_completo }} che regola e definisce gli obblighi reciproci;</li>
        </ul>

        <h4>ATTESO CHE</h4>
        <p>quanto sopra indicato costituisce parte integrante del presente contratto che viene stipulato ai sensi della L. 240/2010 art. 24, nonché della normativa relativa ai contratti di lavoro delle università;</p>

        <h4>STIPULA</h4>
        <p>Con {{ $contratto->anagrafica->nome_completo }}, c.f. {{ $contratto->anagrafica->codice_fiscale }} nato/a a {{ $contratto->anagrafica->luogo_nascita }}, il {{ \Carbon\Carbon::parse($contratto->anagrafica->data_nascita)->format('d/m/Y') }}, residente in {{ $contratto->anagrafica->indirizzo_residenza }}</p>

        <h4>IL SEGUENTE CONTRATTO INDIVIDUALE DI LAVORO</h4>

        <h4>Art. 1 - Tipologia del rapporto di lavoro</h4>
        <p>Il presente contratto di lavoro subordinato a tempo determinato è stipulato ai sensi dell'art. 24 della Legge 240/2010.</p>

        <h4>Art. 2 - Decorrenza e durata</h4>
        <p>Il contratto ha durata triennale con decorrenza dal {{ \Carbon\Carbon::parse($contratto->data_inizio)->format('d/m/Y') }} al {{ \Carbon\Carbon::parse($contratto->data_fine)->format('d/m/Y') }}.</p>

        <h4>Art. 3 - Oggetto della prestazione</h4>
        <p>L'attività di ricerca, di didattica, di didattica integrativa e di servizio agli studenti si svolgerà nell'ambito del settore scientifico-disciplinare {{ $contratto->ssd }} e comprenderà:</p>
        <ul class="bullet-list">
            <li>attività di ricerca scientifica nell'ambito del settore concorsuale;</li>
            <li>attività didattica, didattica integrativa e di servizio agli studenti nell'ambito della programmazione effettuata dal Dipartimento;</li>
            <li>partecipazione alle Commissioni di verifica del profitto degli studenti e di prova finale per il conseguimento del titolo di studio rilasciato dall'Università;</li>
            <li>attività di tutorato e orientamento degli studenti ai fini della predisposizione del piano di studi, nonché attività di assistenza nella elaborazione delle tesi di laurea;</li>
            <li>partecipazione agli organi accademici e alle commissioni dei Corsi di Studio secondo quanto stabilito dallo Statuto dell'Università;</li>
            <li>aggiornamento scientifico e professionale nell'ambito dei settori scientifico-disciplinari di riferimento.</li>
        </ul>

        <h4>Art. 4 - Trattamento economico</h4>
        <p>Il trattamento economico annuo lordo onnicomprensivo è pari a € {{ number_format($contratto->compenso, 2, ',', '.') }}.</p>

        <h4>Art. 5 - Trattamento previdenziale ed assicurativo</h4>
        <p>Il rapporto di lavoro è regolato dalle disposizioni vigenti in materia di lavoro subordinato per quanto attiene al trattamento fiscale, assistenziale e previdenziale.</p>

        <h4>Art. 6 - Incompatibilità</h4>
        <p>Il rapporto di lavoro è incompatibile con:</p>
        <ul class="bullet-list">
            <li>qualsiasi altro rapporto di lavoro subordinato presso soggetti pubblici e privati;</li>
            <li>la titolarità degli assegni di ricerca anche presso altri Atenei;</li>
            <li>la titolarità dei contratti di didattica disciplinati dalle vigenti disposizioni in materia;</li>
            <li>le borse di dottorato e post-dottorato e in generale con qualsiasi borsa di studio o assegno a qualunque titolo conferiti anche da enti terzi.</li>
        </ul>

        <h4>Art. 7 - Risoluzione del rapporto di lavoro</h4>
        <p>La cessazione del rapporto di lavoro è determinata dalla scadenza del termine o dal recesso di una delle parti.</p>

        <div class="signature">
            <table width="100%">
                <tr>
                    <td width="50%">
                        <p>Il Direttore Generale<br>
                        dell'Università Telematica degli Studi IUL<br>
                        Dott. Massimiliano Bizzocchi</p>
                        <div class="signature-line"></div>
                    </td>
                    <td width="50%">
                        <p>Il Ricercatore<br>
                        {{ $contratto->anagrafica->nome_completo }}</p>
                        <div class="signature-line"></div>
                    </td>
                </tr>
            </table>
        </div>

        <div class="digital-signature-notice">
            <p>Documento informatico firmato digitalmente ai sensi del T.U. 445/2000 e del D.Lgs. 82/2005 e rispettive norme collegate, il quale sostituisce il documento cartaceo e la firma autografa</p>
        </div>
    </div>
</body>
</html> 