<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Contratto di Lavoro Dipendente</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.6;
            color: #000;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 20px;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
        }
        .content {
            margin: 20px 0;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            font-size: 10px;
            color: #666;
            padding: 10px;
            text-align: left;
        }
        .signatures {
            margin-top: 50px;
        }
        .signature-line {
            margin: 30px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('images/logo-iul2.png'))) }}" class="logo" alt="Logo IUL">
    </div>

    <div class="title">
        CONTRATTO DI LAVORO DIPENDENTE<br>
        A TEMPO {{ strtoupper($contratto->tipo_tempo ?? 'INDETERMINATO') }}
    </div>

    <div class="content">
        <p>L'UNIVERSITA TELEMATICA DEGLI STUDI IUL, con sede in Firenze, via Buonarroti, n. 10, codice fiscale C.F. 05666530489, rappresentato per il presente atto dal Dott. Massimiliano Bizzocchi nella sua qualità di Direttore Generale dell'Ente, nato a Roma il 27.11.1974</p>
        
        <p>E</p>
        
        <p>{{ $anagrafica->nome }} {{ $anagrafica->cognome }}, CF {{ $anagrafica->codice_fiscale }}, nato/a a {{ $anagrafica->luogo_nascita }} il {{ \Carbon\Carbon::parse($anagrafica->data_nascita)->format('d/m/Y') }}, residente in {{ $anagrafica->indirizzo_residenza }} (di seguito denominato "Collaboratore");</p>

        <h4>PREMESSE</h4>
        <p>Considerato che con Decreto del Ministero dell'Istruzione, dell'Università e della Ricerca in data 2 dicembre 2005, pubblicato nella Gazzetta Ufficiale del 5 gennaio 2006, è stata istituita l'Università telematica degli Studi IUL, non statale, abilitata ai sensi del D.M. 17/04/2003 a rilasciare titoli accademici;</p>
        
        <p>Visto lo Statuto dell'Università Telematica degli Studi IUL;</p>
        
        <p>Preso atto che ai sensi della normativa vigente, deve essere stipulato apposito contratto individuale di lavoro tra l'Università Telematica degli Studi IUL e {{ $anagrafica->nome }} {{ $anagrafica->cognome }}, che regola e definisce gli obblighi reciproci;</p>
        
        <p>Richiamato il D.Lgs n.81/2015 art.1 e successive modifiche ai sensi della Legge 96/2018;</p>
        
        <p>Considerato che è interesse delle parti stipulare un contratto di lavoro subordinato a tempo {{ $contratto->tipo_tempo ?? 'indeterminato' }};</p>

        <h4>STIPULANO IL SEGUENTE CONTRATTO INDIVIDUALE DI LAVORO</h4>

        <h4>Articolo 1 - Tipologia del rapporto di lavoro</h4>
        <p>Il dipendente viene assunto dall'Università Telematica degli Studi IUL con rapporto di lavoro a tempo {{ $contratto->tipo_orario ?? 'pieno' }} e {{ $contratto->tipo_tempo ?? 'indeterminato' }}.</p>

        <h4>Articolo 2 - Decorrenza, efficacia e CCNL applicato</h4>
        <p>L'assunzione ha decorrenza giuridica ed economica dal {{ \Carbon\Carbon::parse($contratto->data_inizio)->format('d/m/Y') }}.</p>
        <p>Al rapporto di lavoro viene applicato il CCNL per i Dipendenti da Aziende del Terziario della Distribuzione e dei Servizi.</p>

        <h4>Articolo 3 - Inquadramento e sede di lavoro</h4>
        <p>Il dipendente viene inquadrato nel Profilo di {{ $contratto->profilo }}, presso la sede di Firenze.</p>

        <h4>Articolo 4 - Mansioni e orario di lavoro</h4>
        <p>Il dipendente è tenuto allo svolgimento delle mansioni corrispondenti al profilo d'inquadramento con particolare riguardo alle attività {{ $contratto->mansioni }}.</p>
        <p>L'orario di lavoro sarà di {{ $contratto->ore_settimanali ?? '40' }} ore settimanali distribuito su cinque giorni dal lunedì al venerdì.</p>

        <h4>Articolo 5 - Trattamento economico</h4>
        <p>La retribuzione è quella prevista dal C.C.N.L. per il personale impiegato di {{ $contratto->livello ?? 'III' }} livello.</p>
        <p>La retribuzione lorda mensile complessiva è di Euro {{ number_format($contratto->retribuzione_mensile, 2, ',', '.') }} e una Retribuzione lorda annua pari a Euro {{ number_format($contratto->retribuzione_annua, 2, ',', '.') }}.</p>

        <div class="signatures">
            <p>Firenze, {{ \Carbon\Carbon::now()->format('d/m/Y') }}</p>
            
            <div class="signature-line">
                <p>Il Dipendente</p>
                <p>____________________________</p>
            </div>

            <div class="signature-line">
                <p>Il DIRETTORE GENERALE</p>
                <p>Dott. Massimiliano Bizzocchi</p>
                <p>____________________________</p>
            </div>
        </div>
    </div>

    <div class="footer">
        <p>50122 Firenze, Via M. Buonarroti 10 - cod. fis./p. iva 056665304489 - tel. +39 055 0380900 - www.iuline.it</p>
    </div>
</body>
</html> 