<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Contratto di Collaborazione Coordinata e Continuativa</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.6;
            color: #000;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 20px;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
        }
        .content {
            margin: 20px 0;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            font-size: 10px;
            color: #666;
            padding: 10px;
            text-align: left;
        }
        .signatures {
            margin-top: 50px;
        }
        .signature-line {
            margin: 30px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('images/logo-iul2.png'))) }}" class="logo" alt="Logo IUL">
    </div>

    <div class="title">
        CONTRATTO DI COLLABORAZIONE COORDINATA E CONTINUATIVA
    </div>

    <div class="content">
        <p>TRA</p>

        <p>L'Università telematica degli Studi IUL con sede legale in Firenze, via Michelangelo Buonarroti 10 – 50122, Codice Fiscale/P.IVA 05666530489, rappresentata dal Direttore Generale, Dott. Massimiliano Bizzocchi, nato a Roma il 27/11/1974, C.F. BZZMSM74S27H501A, domiciliato per la carica presso la sede dell'Università stessa (di seguito denominata "Committente")</p>

        <p>E</p>

        <p>{{ $anagrafica->nome }} {{ $anagrafica->cognome }}, CF {{ $anagrafica->codice_fiscale }}, nato/a a {{ $anagrafica->luogo_nascita }} il {{ \Carbon\Carbon::parse($anagrafica->data_nascita)->format('d/m/Y') }}, residente in {{ $anagrafica->indirizzo_residenza }} (di seguito denominato "Collaboratore");</p>

        <h4>PREMESSO</h4>
        <ul>
            <li>che i rapporti di collaborazione coordinata e continuativa sono attualmente regolamentati dal D.lgs 81/2015;</li>
            <li>che l'art. 2, comma 2, del D.lgs 81/2015 prevede la possibilità di regolare le collaborazioni coordinate e continuative con accordi collettivi nazionali che prevedano discipline specifiche riguardanti il trattamento economico e normativo in ragione delle particolari esigenze produttive ed organizzative del relativo settore;</li>
            <li>che in data 10 dicembre 2015 le Università non statali e le OO.SS. hanno sottoscritto un "Accordo collettivo nazionale di riferimento per i Collaboratori delle Università non statali";</li>
        </ul>

        <h4>CONSIDERATO</h4>
        <ul>
            <li>che l'Università Telematica degli Studi IUL intende avvalersi dell'istituto contrattuale delle collaborazioni coordinate e continuative, con soggetti particolarmente ed oggettivamente in possesso di comprovata esperienza professionale;</li>
            <li>che {{ $anagrafica->nome }} {{ $anagrafica->cognome }} è reso/a disponibile a fornire la propria collaborazione lavorativa;</li>
            <li>che è interesse esclusivo delle parti stipulare un contratto contenente gli elementi specifici della collaborazione coordinata e continuativa.</li>
        </ul>

        <h4>SI CONVIENE e SI STIPULA QUANTO SEGUE</h4>

        <h4>Art. 1 - OGGETTO DELLA COLLABORAZIONE</h4>
        <p>Il Collaboratore si impegna a svolgere a favore dell'Università attività di {{ $contratto->oggetto_incarico ?? 'collaborazione' }}.</p>

        <h4>Art. 2 - MODALITA' DI SVOLGIMENTO DELLA COLLABORAZIONE</h4>
        <p>Il Collaboratore si obbliga ad eseguire la prestazione personalmente, nell'ambito prestabilito dal Committente stesso per il perseguimento degli obiettivi di cui al presente contratto, senza alcun vincolo di subordinazione gerarchica e disciplinare con il Committente, in piena autonomia organizzativa e operativa.</p>

        <h4>Art. 3 - DECORRENZA E DURATA</h4>
        <p>Il presente contratto ha una durata di {{ $contratto->durata ?? 'mesi' }} con decorrenza dal giorno {{ \Carbon\Carbon::parse($contratto->data_inizio)->format('d/m/Y') }}. Si esclude la rinnovabilità tacita dello stesso.</p>

        <h4>Art. 4 - OBBLIGO DI RISERVATEZZA E DIRITTO D'AUTORE</h4>
        <p>Il Collaboratore si impegna a mantenere la più ampia riservatezza su quanto concerne i dati, le notizie e, in genere, le attività connesse all'esecuzione del presente contratto.</p>
        <p>E' fatto, pertanto, divieto al Collaboratore di comunicare o divulgare qualsiasi tipo di informazione o notizia inerente all'organizzazione dell'Università ed alla relativa attività di cui sia venuto a conoscenza nell'esecuzione del presente contratto.</p>
        <p>Il lavoro svolto dal Collaboratore e i risultati dello stesso sono di esclusiva proprietà dell'Università, la quale ne potrà disporre a suo insindacabile giudizio.</p>

        <h4>Art. 5 - TRATTAMENTO ECONOMICO</h4>
        <p>Per la collaborazione descritta nel precedente punto n. 1, il Committente si impegna a corrispondere al Collaboratore il compenso di Euro {{ number_format($contratto->compenso, 2, ',', '.') }} al lordo di IRPEF e al netto della quota del contributo previdenziale obbligatoriamente a carico del Committente.</p>
        <p>Il compenso sarà assoggettato alla contribuzione alla "Gestione Separata INPS" e all'INAIL nella misura percentuale prevista per i soggetti, come il Collaboratore, già iscritti a gestioni previdenziali.</p>
        <p>Il compenso sarà accreditato sul conto corrente bancario intestato al medesimo e di cui successivamente sarà fornito l'IBAN.</p>
        <p>Il Collaboratore oltre al compenso di cui sopra, non potrà avere null'altro a pretendere, né nel corso del rapporto, né a seguito della sua estinzione, per nessuna ragione o causale estranea alla natura dello stesso rapporto di collaborazione. Il pagamento sarà corrisposto mediante rate periodiche.</p>

        <div class="signatures">
            <p>Firenze, {{ \Carbon\Carbon::now()->format('d/m/Y') }}</p>

            <div class="signature-line">
                <p>Università Telematica degli Studi IUL<br>
                Il Direttore Generale<br>
                Dott. Massimiliano Bizzocchi</p>
                <p>____________________________</p>
            </div>

            <div class="signature-line">
                <p>Il Collaboratore</p>
                <p>____________________________</p>
            </div>
        </div>
    </div>

    <div class="footer">
        <p>50122 Firenze, Via M. Buonarroti 10 - cod. fis./p. iva 056665304489 - tel. +39 055 0380900 - www.iuline.it</p>
    </div>
</body>
</html> 