<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Contratto di Collaborazione Autonoma</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.6;
            color: #000;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 20px;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
        }
        .content {
            margin: 20px 0;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            font-size: 10px;
            color: #666;
            padding: 10px;
            text-align: left;
        }
        .signatures {
            margin-top: 50px;
        }
        .signature-line {
            margin: 30px 0;
        }
        h4 {
            margin-top: 20px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('images/logo-iul2.png'))) }}" class="logo" alt="Logo IUL">
    </div>

    <div class="title">
        CONTRATTO DI COLLABORAZIONE AUTONOMA
    </div>

    <div class="content">
        <p>TRA</p>

        <p>L'Università Telematica degli Studi IUL, con sede legale in Firenze, via Michelangelo Buonarroti 10 – 50122, Codice Fiscale/P.IVA 05666530489, rappresentata dal Direttore Generale, Dott. Massimiliano Bizzocchi, nato a Roma il 27/11/1974, C.F. BZZMSM74S27H501A, domiciliato per la carica presso la sede dell'Università (di seguito denominata "Committente")</p>

        <p>E</p>

        <p>{{ $anagrafica->nome }} {{ $anagrafica->cognome }}, residente in {{ $anagrafica->indirizzo_residenza }} {{ $anagrafica->numero_civico_residenza }}, {{ $anagrafica->cap_residenza }} {{ $anagrafica->citta_residenza }}, CF {{ $anagrafica->codice_fiscale }}, nato/a a {{ $anagrafica->luogo_nascita }} il {{ \Carbon\Carbon::parse($anagrafica->data_nascita)->format('d/m/Y') }} (di seguito denominato anche "Collaboratore")</p>

        <h4>CONSIDERATO</h4>
        <ul>
            <li>che l'Università Telematica degli Studi IUL intende avvalersi dell'istituto contrattuale della collaborazione autonoma per le proprie attività;</li>
            <li>che {{ $anagrafica->nome }} {{ $anagrafica->cognome }} si è reso disponibile a fornire la propria opera lavorativa;</li>
            <li>che è interesse esclusivo delle parti stipulare un contratto contenente gli elementi specifici della collaborazione autonoma;</li>
            <li>che {{ $anagrafica->nome }} {{ $anagrafica->cognome }} è titolare di partita IVA n. {{ $anagrafica->partita_iva }};</li>
        </ul>

        <p>Tutto ciò premesso e considerato da formare parte integrante e sostanziale del presente contratto</p>

        <h4>SI CONVIENE e SI STIPULA QUANTO SEGUE</h4>

        <p>Le premesse formano parte integrante e sostanziale del presente contratto, così come le pattuizioni che seguono e ciascuna di esse è presupposto essenziale e determinante per l'interpretazione della volontà delle parti così come di seguito manifestata; le parti si obbligano reciprocamente al loro rispetto. Ai fini dell'interpretazione della volontà negoziale espressa nella presente scrittura, non potranno essere utilizzate precedenti proposte o quanto ha formato oggetto di trattativa per addivenire alla conclusione di questo atto. Le modifiche al presente atto potranno essere apportate solo con altro atto sottoscritto dalle parti.</p>

        <h4>Art. 1 - OGGETTO DELLA COLLABORAZIONE</h4>
        <p>Il Collaboratore si impegna a svolgere a favore dell'Università attività {{ $contratto->descrizione_incarico }}.</p>

        <h4>Art. 2 - MODALITA' DI SVOLGIMENTO DELLA COLLABORAZIONE</h4>
        <p>Il Collaboratore si obbliga ad eseguire la prestazione personalmente, nell'ambito prestabilito dal Committente stesso per il perseguimento degli obiettivi di cui al presente contratto, senza alcun vincolo di subordinazione gerarchica e disciplinare con il Committente, in piena autonomia organizzativa e operativa. Il Collaboratore si impegna ad inviare al Committente relazione mensile delle attività svolte al fine di determinare il corretto svolgimento delle proprie prestazioni professionali.</p>

        <h4>Art. 3 - DECORRENZA E DURATA</h4>
        <p>Il presente contratto ha la durata di {{ \Carbon\Carbon::parse($contratto->data_fine)->diffInMonths($contratto->data_inizio) }} mesi a decorrere dal giorno {{ \Carbon\Carbon::parse($contratto->data_inizio)->format('d/m/Y') }}.</p>
        <p>Ciascuna delle Parti potrà in ogni caso recedere dal presente contratto con un preavviso di almeno 30 (trenta) giorni a mezzo di lettera raccomandata, fatta salva la facoltà per entrambe le parti di risolvere immediatamente il rapporto per giusta causa.</p>
        <p>In tali ipotesi, l'Università provvederà al pagamento, in relazione al compenso stabilito nel presente contratto, del lavoro regolarmente eseguito in relazione all'utilità della parte di prestazione compiuta.</p>

        <h4>Art. 4 - OBBLIGO DI RISERVATEZZA E DIRITTO D'AUTORE</h4>
        <p>Il Collaboratore si impegna a mantenere la più ampia riservatezza su quanto concerne i dati, le notizie e, in genere, le attività connesse all'esecuzione del presente contratto.</p>
        <p>E' fatto, pertanto, divieto al Collaboratore di comunicare o divulgare qualsiasi tipo di informazione o notizia inerente all'organizzazione dell'Università ed alla relativa attività di cui sia venuto a conoscenza nell'esecuzione del presente contratto.</p>
        <p>Il lavoro svolto dal Collaboratore e i risultati dello stesso sono di esclusiva proprietà dell'Università, la quale ne potrà disporre a suo insindacabile giudizio.</p>

        <h4>Art. 5 - TRATTAMENTO ECONOMICO</h4>
        <p>Per la collaborazione descritta nei precedenti punti, il Committente si impegna a corrispondere al Collaboratore il compenso annuo di Euro {{ number_format($contratto->compenso, 2, ',', '.') }} ({{ $contratto->compenso_lettere }}/00) al lordo di IRPEF ed al netto di IVA e cassa.</p>
        <p>La liquidazione dell'importo avverrà mensilmente previa presentazione di fattura elettronica e dopo valutazione positiva dell'attività svolta da parte dell'Amministrazione.</p>
        <p>Il Collaboratore, oltre a quanto sopra, non potrà avere null'altro a pretendere, né nel corso del rapporto, né a seguito della sua estinzione, per nessuna ragione o causale estranea alla natura del rapporto di collaborazione.</p>

        <h4>Art. 6 - RESPONSABILITÀ</h4>
        <p>Il Collaboratore svolgerà l'incarico concordato sotto la propria completa responsabilità e, per questo, si impegna a risarcire ogni danno a persona o cose che dovesse verificarsi per fatto imputabile allo stesso.</p>

        <h4>Art. 7 - TRATTAMENTO DEI DATI PERSONALI</h4>
        <p>Tutti i dati personali contenuti nel presente incarico saranno trattati dall'Ateneo nel rispetto della legislazione vigente ai sensi del Regolamento UE 2016/679 - Regolamento Generale per la Protezione dei Dati (GDPR).</p>

        <h4>Art. 8 - FORO COMPETENTE</h4>
        <p>Ogni controversia nascente dal presente Contratto o ad esso relativa, incluse le controversie relative all'esistenza, alla validità, all'interpretazione, all'esecuzione, all'inadempimento o alla risoluzione dello stesso Contratto, sarà devoluta in via esclusiva al giudice competente del Foro di Firenze.</p>

        <h4>Art. 9 - NORMA FINALE</h4>
        <p>Le parti si danno atto di aver preventivamente conosciuto e approvato tutte le clausole del presente contratto. Il Collaboratore, in particolare, dichiara di ritenersi completamente soddisfatto del compenso pattuito e di null'altro esigere in relazione all'incarico stesso.</p>

        <div class="signatures">
            <p>Firenze, {{ \Carbon\Carbon::now()->format('d/m/Y') }}</p>

            <table width="100%">
                <tr>
                    <td width="50%">
                        <p>Università Telematica degli Studi IUL<br>
                        Il Direttore Generale<br>
                        Dott. Massimiliano Bizzocchi</p>
                        <div class="signature-line"></div>
                    </td>
                    <td width="50%">
                        <p>Il Collaboratore<br>
                        {{ $anagrafica->nome }} {{ $anagrafica->cognome }}</p>
                        <div class="signature-line"></div>
                    </td>
                </tr>
            </table>
        </div>
    </div>

    <div class="footer">
        <p>50122 Firenze, Via M. Buonarroti 10 - cod. fis./p. iva 056665304489 - tel. +39 055 0380900 - www.iuline.it</p>
    </div>
</body>
</html> 