<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 40px;
        }
        .header img {
            width: 250px;
            height: auto;
        }
        .main-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        .main-table th, .main-table td {
            border: 1px solid #000;
            padding: 10px;
            text-align: left;
        }
        .main-table th {
            background-color: #E6EEF9;
            font-weight: normal;
            text-align: center;
        }
        .main-table td {
            background-color: white;
        }
        .director-info {
            margin-bottom: 30px;
            line-height: 2;
        }
        .director-line {
            display: block;
            margin-bottom: 10px;
        }
        .director-line::after {
            content: "";
            display: inline-block;
            width: 70%;
            margin-left: 10px;
            border-bottom: 1px solid #000;
        }
        .section-title {
            background-color: #E6EEF9;
            padding: 10px;
            margin-bottom: 0;
            font-weight: normal;
            text-align: center;
            border: 1px solid #000;
            border-bottom: none;
        }
        .content-box {
            border: 1px solid #000;
            padding: 20px;
            margin-bottom: 30px;
            min-height: 100px;
            background-color: white;
        }
        .modules-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .modules-table th, .modules-table td {
            border: 1px solid #000;
            padding: 10px;
            text-align: center;
            background-color: white;
        }
        .modules-table th {
            background-color: #E6EEF9;
        }
        .note {
            font-size: 0.9em;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ public_path('assets/loghi/iul.jpg') }}" alt="IUL Logo">
    </div>

    <table class="main-table">
        <tr>
            <th>Titolo</th>
            <th>Tip. Percorso</th>
            <th>Titolo<br>Esteso</th>
            <th>CFU</th>
            <th>Modalità di<br>erogazione</th>
            <th>a.a</th>
        </tr>
        <tr>
            <td>{{ $proposta->titolo }}</td>
            <td>{{ $proposta->tipologia_percorso }}</td>
            <td>{{ $proposta->titolo_esteso }}</td>
            <td style="text-align: center;">{{ $proposta->cfu }}</td>
            <td style="text-align: center;">{{ $proposta->modalita_erogazione }}</td>
            <td style="text-align: center;">{{ $proposta->anno_accademico }}</td>
        </tr>
    </table>

    <div class="director-info">
        <span class="director-line">Direttore del corso: {{ $proposta->direttore_corso }}</span>
        <span class="director-line">Coordinatore del corso: {{ $proposta->coordinatore_corso }}</span>
    </div>

    <div class="section">
        <div class="section-title">OBIETTIVI E FINALITÀ</div>
        <div class="content-box">
            {!! Str::markdown($proposta->obiettivi_finalita) !!}
        </div>
    </div>

    <div class="section">
        <div class="section-title">CONTENUTI</div>
        <div class="content-box">
            <div class="note">(numero e denominazione dei moduli, settori scientifico-disciplinari – s.s.d., CFU x modulo, ore x modulo – 1CFU = 25 ore)</div>
            <table class="modules-table">
                <tr>
                    <th>Moduli</th>
                    <th>SSD</th>
                    <th>CFU</th>
                    <th>Tot. Ore</th>
                </tr>
                @foreach($proposta->moduli as $modulo)
                <tr>
                    <td>{{ $modulo->titolo }}</td>
                    <td>{{ $modulo->ssd }}</td>
                    <td>{{ $modulo->cfu }}</td>
                    <td>{{ $modulo->ore_totali }}</td>
                </tr>
                @endforeach
            </table>
        </div>
    </div>

    <div class="section">
        <div class="section-title">DESTINATARI</div>
        <div class="content-box">
            {!! Str::markdown($proposta->destinatari) !!}
        </div>
    </div>

    <div class="section">
        <div class="section-title">DURATA</div>
        <div class="content-box">
            {!! Str::markdown($proposta->durata) !!}
        </div>
    </div>

    <div class="section">
        <div class="section-title">COERENZA DELLA METODOLOGIA DIDATTICA CON MODELLO IUL</div>
        <div class="content-box">
            {!! Str::markdown($proposta->coerenza_metodologia) !!}
        </div>
    </div>

    <div class="section">
        <div class="section-title">MODALITÀ DI CONSEGUIMENTO TITOLO</div>
        <div class="content-box">
            {!! Str::markdown($proposta->modalita_conseguimento) !!}
        </div>
    </div>

    <div class="section">
        <div class="section-title">COSTO ISCRIZIONE</div>
        <div class="content-box">
            {!! Str::markdown($proposta->costo_iscrizione) !!}
        </div>
    </div>

    @if($proposta->partner_scientifici)
    <div class="section">
        <div class="section-title">EVENTUALI PARTNER SCIENTIFICI</div>
        <div class="content-box">
            {!! Str::markdown($proposta->partner_scientifici) !!}
        </div>
    </div>
    @endif

    @if($proposta->partner_organizzativi)
    <div class="section">
        <div class="section-title">EVENTUALI PARTNER ORGANIZZATIVI</div>
        <div class="content-box">
            {!! Str::markdown($proposta->partner_organizzativi) !!}
        </div>
    </div>
    @endif
</body>
</html> 